/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.elements;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.AnimatedGuiElement;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AnimatedGuiElementBuilder
implements GuiElementBuilderInterface<AnimatedGuiElementBuilder> {
    protected final Map<class_1887, Integer> enchantments = new HashMap<class_1887, Integer>();
    protected final List<class_1799> itemStacks = new ArrayList<class_1799>();
    protected class_1792 item = class_1802.field_20391;
    protected class_2487 tag;
    protected int count = 1;
    protected class_2561 name = null;
    protected List<class_2561> lore = new ArrayList<class_2561>();
    protected int damage = -1;
    protected GuiElementInterface.ClickCallback callback = GuiElement.EMPTY_CALLBACK;
    protected byte hideFlags = 0;
    protected int interval = 1;
    protected boolean random = false;

    public AnimatedGuiElementBuilder setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public AnimatedGuiElementBuilder setRandom(boolean value) {
        this.random = value;
        return this;
    }

    public AnimatedGuiElementBuilder saveItemStack() {
        this.itemStacks.add(this.asStack());
        this.item = class_1802.field_20391;
        this.tag = null;
        this.count = 1;
        this.name = null;
        this.lore = new ArrayList<class_2561>();
        this.damage = -1;
        this.hideFlags = 0;
        this.enchantments.clear();
        return this;
    }

    public AnimatedGuiElementBuilder setItem(class_1792 item) {
        this.item = item;
        return this;
    }

    public AnimatedGuiElementBuilder setName(class_2561 name) {
        this.name = name.method_27661();
        return this;
    }

    public AnimatedGuiElementBuilder setCount(int count) {
        this.count = count;
        return this;
    }

    public AnimatedGuiElementBuilder setLore(List<class_2561> lore) {
        this.lore = lore;
        return this;
    }

    public AnimatedGuiElementBuilder addLoreLine(class_2561 lore) {
        this.lore.add(lore);
        return this;
    }

    public AnimatedGuiElementBuilder setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public AnimatedGuiElementBuilder hideFlags() {
        this.hideFlags = (byte)127;
        return this;
    }

    public AnimatedGuiElementBuilder hideFlag(class_1799.class_5422 section) {
        this.hideFlags = (byte)(this.hideFlags | section.method_30269());
        return this;
    }

    public AnimatedGuiElementBuilder hideFlags(byte value) {
        this.hideFlags = value;
        return this;
    }

    public AnimatedGuiElementBuilder enchant(class_1887 enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public AnimatedGuiElementBuilder glow() {
        this.enchantments.put(class_1893.field_9114, 1);
        return this.hideFlag(class_1799.class_5422.field_25768);
    }

    public AnimatedGuiElementBuilder setCustomModelData(int value) {
        this.getOrCreateNbt().method_10569("CustomModelData", value);
        return this;
    }

    public AnimatedGuiElementBuilder unbreakable() {
        this.getOrCreateNbt().method_10556("Unbreakable", true);
        return this.hideFlag(class_1799.class_5422.field_25770);
    }

    public AnimatedGuiElementBuilder setSkullOwner(String value) {
        return this.setSkullOwner(value, null, null);
    }

    public AnimatedGuiElementBuilder setSkullOwner(GameProfile profile, @Nullable MinecraftServer server) {
        if (profile.getId() != null && server != null) {
            ProfileResult tmp;
            if (server.method_3844().getTextures(profile, false).isEmpty() && (tmp = server.method_3844().fetchProfile(profile.getId(), false)) != null) {
                profile = tmp.profile();
            }
            this.getOrCreateNbt().method_10566("SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)profile));
        } else {
            this.getOrCreateNbt().method_10582("SkullOwner", profile.getName());
        }
        return this;
    }

    public AnimatedGuiElementBuilder setSkullOwner(String value, @Nullable String signature, @Nullable UUID uuid) {
        class_2487 skullOwner = new class_2487();
        class_2487 properties = new class_2487();
        class_2487 valueData = new class_2487();
        class_2499 textures = new class_2499();
        valueData.method_10582("Value", value);
        if (signature != null) {
            valueData.method_10582("Signature", signature);
        }
        textures.add((Object)valueData);
        properties.method_10566("textures", (class_2520)textures);
        skullOwner.method_10566("Id", (class_2520)class_2512.method_25929((UUID)(uuid != null ? uuid : class_156.field_25140)));
        skullOwner.method_10566("Properties", (class_2520)properties);
        this.getOrCreateNbt().method_10566("SkullOwner", (class_2520)skullOwner);
        return this;
    }

    @Override
    public AnimatedGuiElementBuilder setCallback(GuiElementInterface.ClickCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public AnimatedGuiElementBuilder setCallback(GuiElementInterface.ItemClickCallback callback) {
        this.callback = callback;
        return this;
    }

    public class_1799 asStack() {
        class_1799 itemStack = new class_1799((class_1935)this.item, this.count);
        if (this.tag != null) {
            itemStack.method_7948().method_10543(this.tag);
        }
        if (this.name != null) {
            class_5250 name = this.name.method_27661().method_27694(GuiHelpers.STYLE_CLEARER);
            itemStack.method_7977((class_2561)name);
        }
        if (this.item.method_7846() && this.damage != -1) {
            itemStack.method_7974(this.damage);
        }
        for (Map.Entry entry : this.enchantments.entrySet()) {
            itemStack.method_7978((class_1887)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        if (this.lore.size() > 0) {
            class_2487 display = itemStack.method_7911("display");
            class_2499 class_24992 = new class_2499();
            for (class_2561 l : this.lore) {
                l = l.method_27661().method_27694(GuiHelpers.STYLE_CLEARER);
                class_24992.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)l)));
            }
            display.method_10566("Lore", (class_2520)class_24992);
        }
        if (this.hideFlags != 0) {
            itemStack.method_7948().method_10567("HideFlags", this.hideFlags);
        }
        return itemStack;
    }

    public class_2487 getOrCreateNbt() {
        if (this.tag == null) {
            this.tag = new class_2487();
        }
        return this.tag;
    }

    @Override
    public AnimatedGuiElement build() {
        return new AnimatedGuiElement(this.itemStacks.toArray(new class_1799[0]), this.interval, this.random, this.callback);
    }
}

