/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.ModMetaFile;
import dev.lukebemish.defaultresources.impl.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public record Config(HashMap<String, ExtractionState> extract) {
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_3542.method_28140(ExtractionState::values)).xmap(HashMap::new, Function.identity()).fieldOf("extract").forGetter(Config::extract)).apply((Applicative)i, Config::new));
    public static final Supplier<Config> INSTANCE = Suppliers.memoize(Config::readFromConfig);

    private static Config getDefault() {
        return new Config(new HashMap<String, ExtractionState>());
    }

    private static Config readFromConfig() {
        Path configPath = Services.PLATFORM.getConfigDir().resolve("defaultresources.json");
        Config config = Config.getDefault();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                JsonElement json = (JsonElement)DefaultResources.GSON.fromJson((Reader)Files.newBufferedReader(configPath), JsonElement.class);
                config = (Config)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> DefaultResources.LOGGER.error("Error parsing {}.json config; using (and replacing) with default: {}", (Object)"defaultresources", e));
            }
            catch (IOException e2) {
                DefaultResources.LOGGER.error("Could not read {}.json config; using (and replacing) with default.", (Object)"defaultresources", (Object)e2);
            }
            catch (JsonSyntaxException e3) {
                DefaultResources.LOGGER.error("Error parsing {}.json config; using (and replacing) with default.", (Object)"defaultresources", (Object)e3);
            }
            catch (RuntimeException e3) {
                // empty catch block
            }
        }
        HashMap<String, ExtractionState> map = new HashMap<String, ExtractionState>(config.extract());
        Services.PLATFORM.getExistingModdedPaths("defaultresources.meta.json").forEach((modId, metaPath) -> {
            try (InputStream is = Files.newInputStream(metaPath, new OpenOption[0]);){
                JsonElement object = (JsonElement)DefaultResources.GSON.fromJson((Reader)new InputStreamReader(is), JsonElement.class);
                ModMetaFile metaFile = (ModMetaFile)ModMetaFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow(false, e -> {});
                if (!map.containsKey(modId)) {
                    map.put((String)modId, metaFile.extractsByDefault() ? ExtractionState.EXTRACT : ExtractionState.UNEXTRACTED);
                }
            }
            catch (IOException | RuntimeException e2) {
                DefaultResources.LOGGER.warn("We thought there was a readable {} for mod {}, but we got an error when reading it!", (Object)"defaultresources.meta.json", modId, (Object)e2);
            }
        });
        config = new Config(map);
        try {
            Config.writeConfig(configPath, config);
        }
        catch (IOException e4) {
            DefaultResources.LOGGER.error("Could not write {}.json config. There may be odd behavior. ", (Object)"defaultresources", (Object)e4);
        }
        return config;
    }

    private static void writeConfig(Path path, Config config) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.deleteIfExists(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("// Set extraction to \"extract\" to extract currently unextracted resources.\n");
            DefaultResources.GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(false, e -> {}), (Appendable)writer);
        }
    }

    public void save() {
        Path configPath = Services.PLATFORM.getConfigDir().resolve("defaultresources.json");
        try {
            Config.writeConfig(configPath, this);
        }
        catch (IOException e) {
            DefaultResources.LOGGER.error("Could not save {} config!", (Object)"defaultresources", (Object)e);
        }
    }

    static enum ExtractionState implements class_3542
    {
        UNEXTRACTED(false, false),
        EXTRACT(true, true),
        EXTRACTED(true, false);

        public final boolean extractIfMissing;
        public final boolean extractRegardless;

        private ExtractionState(boolean extractIfMissing, boolean extractRegardless) {
            this.extractIfMissing = extractIfMissing;
            this.extractRegardless = extractRegardless;
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

