/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl.quilt;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import dev.lukebemish.defaultresources.api.ResourceProvider;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.PathResourceProvider;
import dev.lukebemish.defaultresources.impl.Services;
import dev.lukebemish.defaultresources.impl.services.IPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.quiltmc.loader.api.QuiltLoader;

@AutoService(value={IPlatform.class})
public class PlatformImpl
implements IPlatform {
    @Override
    public Path getGlobalFolder() {
        return QuiltLoader.getGameDir().resolve("globalresources");
    }

    @Override
    public void extractResources() {
        try {
            if (!Files.exists(Services.PLATFORM.getGlobalFolder(), new LinkOption[0])) {
                Files.createDirectories(Services.PLATFORM.getGlobalFolder(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            DefaultResources.LOGGER.error((Object)e);
        }
        QuiltLoader.getAllMods().forEach(mod -> {
            String modid = mod.metadata().id();
            if (!modid.equals("minecraft")) {
                DefaultResources.forMod(QuiltLoader.getConfigDir(), mod.rootPath().toAbsolutePath()::resolve, modid);
            }
        });
    }

    @Override
    public Collection<ResourceProvider> getJarProviders() {
        ArrayList<ResourceProvider> providers = new ArrayList<ResourceProvider>();
        QuiltLoader.getAllMods().forEach(mod -> {
            String modid = mod.metadata().id();
            if (!modid.equals("minecraft")) {
                providers.add(new PathResourceProvider(mod.rootPath()));
            }
        });
        return providers;
    }

    @Override
    public Path getConfigDir() {
        return QuiltLoader.getConfigDir();
    }

    @Override
    public Map<String, Path> getExistingModdedPaths(String relative) {
        return QuiltLoader.getAllMods().stream().filter(mod -> !mod.metadata().id().equals("minecraft")).map(mod -> new Pair((Object)mod.metadata().id(), (Object)mod.rootPath().toAbsolutePath().resolve(relative))).filter(it -> it.getSecond() != null && Files.exists((Path)it.getSecond(), new LinkOption[0])).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a));
    }
}

