/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.api;

import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.Services;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;

public interface ResourceProvider {
    public static void forceInitialization() {
        ResourceProvider.instance();
    }

    public static ResourceProvider instance() {
        if (DefaultResources.RESOURCE_PROVIDER == null) {
            Services.PLATFORM.extractResources();
            DefaultResources.cleanupExtraction();
            DefaultResources.RESOURCE_PROVIDER = DefaultResources.assembleResourceProvider();
        }
        return DefaultResources.RESOURCE_PROVIDER;
    }

    @NotNull
    default public IoSupplier<InputStream> getResource(String packType, ResourceLocation location) {
        Optional<? extends InputStream> optional = this.getResourceStreams(packType, location).findFirst();
        if (optional.isEmpty()) {
            return () -> {
                throw new IOException("No resource found at " + location);
            };
        }
        return optional::get;
    }

    @NotNull
    public Collection<ResourceLocation> getResources(String var1, String var2, Predicate<ResourceLocation> var3);

    @NotNull
    public Stream<? extends InputStream> getResourceStreams(String var1, ResourceLocation var2);

    @NotNull
    public Stream<? extends InputStream> getResourceStreams(String var1, Collection<ResourceLocation> var2);
}

