/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import dev.lukebemish.defaultresources.impl.PathResourceProvider;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ZipResourceProvider
extends PathResourceProvider {
    @Nullable
    private FileSystem zipFile;

    public ZipResourceProvider(Path file) {
        super(file);
    }

    private FileSystem getZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = FileSystems.newFileSystem(URI.create("jar:" + this.source.toAbsolutePath().toUri()), Map.of());
        }
        return this.zipFile;
    }

    @Override
    protected Path resolve(String ... paths) throws IOException {
        Path path = this.getZipFile().getPath("/", new String[0]);
        for (String name : paths) {
            path = path.resolve(name);
        }
        return path;
    }
}

