/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl.forge;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import dev.lukebemish.defaultresources.api.ResourceProvider;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.PathResourceProvider;
import dev.lukebemish.defaultresources.impl.Services;
import dev.lukebemish.defaultresources.impl.services.IPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.locating.IModFile;

@AutoService(value={IPlatform.class})
public class PlatformImpl
implements IPlatform {
    @Override
    public Path getGlobalFolder() {
        return FMLPaths.GAMEDIR.get().resolve("globalresources");
    }

    @Override
    public void extractResources() {
        try {
            if (!Files.exists(Services.PLATFORM.getGlobalFolder(), new LinkOption[0])) {
                Files.createDirectories(Services.PLATFORM.getGlobalFolder(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            DefaultResources.LOGGER.error((Object)e);
        }
        FMLLoader.getLoadingModList().getModFiles().stream().flatMap(f -> f.getMods().stream()).filter(mod -> !mod.getModId().equals("forge") && !mod.getModId().equals("minecraft")).forEach(mod -> DefaultResources.forMod(FMLPaths.CONFIGDIR.get(), arg_0 -> PlatformImpl.lambda$extractResources$2(mod.getOwningFile().getFile(), arg_0), mod.getModId()));
    }

    @Override
    public Collection<ResourceProvider> getJarProviders() {
        ArrayList<ResourceProvider> providers = new ArrayList<ResourceProvider>();
        FMLLoader.getLoadingModList().getModFiles().stream().flatMap(f -> f.getMods().stream()).filter(mod -> !mod.getModId().equals("forge") && !mod.getModId().equals("minecraft")).forEach(mod -> providers.add(new PathResourceProvider(mod.getOwningFile().getFile().getSecureJar().getPath(String.join((CharSequence)"/", new CharSequence[0]), new String[0]))));
        return providers;
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Map<String, Path> getExistingModdedPaths(String relative) {
        return FMLLoader.getLoadingModList().getModFiles().stream().flatMap(f -> f.getMods().stream()).filter(mod -> !mod.getModId().equals("forge") && !mod.getModId().equals("minecraft")).map(mod -> new Pair((Object)mod.getModId(), (Object)mod.getOwningFile().getFile().findResource(new String[]{relative}))).filter(it -> it.getSecond() != null && Files.exists((Path)it.getSecond(), new LinkOption[0])).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a));
    }

    private static /* synthetic */ Path lambda$extractResources$2(IModFile rec$, String xva$0) {
        return rec$.findResource(new String[]{xva$0});
    }
}

