/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import dev.lukebemish.defaultresources.api.GlobalResourceManager;
import dev.lukebemish.defaultresources.impl.mixin.ResourceAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jspecify.annotations.Nullable;

public class WrappingResourceManager
implements GlobalResourceManager {
    private final GlobalResourceManager wrapped;
    private final String prefix;

    private static void checkValidPrefix(String prefix) {
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Invalid prefix; prefixes must not be empty.");
        }
        for (char c : prefix.toCharArray()) {
            if (c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("Invalid prefix: \"" + prefix + "\". Prefixes must contain only lowercase letters, numbers, underscores, and dashes.");
        }
    }

    public WrappingResourceManager(GlobalResourceManager wrapped, String prefix) {
        WrappingResourceManager.checkValidPrefix(prefix);
        this.wrapped = wrapped;
        this.prefix = prefix + "/";
    }

    public Set<String> getNamespaces() {
        return this.wrapped.getNamespaces();
    }

    public List<Resource> getResourceStack(ResourceLocation location) {
        ArrayList<Resource> out = new ArrayList<Resource>();
        for (Resource resource : this.wrapped.getResourceStack(location.withPrefix(this.prefix))) {
            out.add(this.wrapResource(resource));
        }
        return out;
    }

    public Map<ResourceLocation, Resource> listResources(String path, Predicate<ResourceLocation> filter) {
        HashMap<ResourceLocation, Resource> out = new HashMap<ResourceLocation, Resource>();
        for (Map.Entry entry : this.wrapped.listResources(this.prefix + path, filter).entrySet()) {
            out.put(this.wrapLocation((ResourceLocation)entry.getKey()), this.wrapResource((Resource)entry.getValue()));
        }
        return out;
    }

    public Map<ResourceLocation, List<Resource>> listResourceStacks(String path, Predicate<ResourceLocation> filter) {
        HashMap<ResourceLocation, List<Resource>> out = new HashMap<ResourceLocation, List<Resource>>();
        for (Map.Entry entry : this.wrapped.listResourceStacks(this.prefix + path, filter).entrySet()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (Resource resource : (List)entry.getValue()) {
                resources.add(this.wrapResource(resource));
            }
            out.put(this.wrapLocation((ResourceLocation)entry.getKey()), resources);
        }
        return out;
    }

    public Stream<PackResources> listPacks() {
        return this.wrapped.listPacks().map(this::wrapResources);
    }

    private Resource wrapResource(Resource resource) {
        if (((ResourceAccessor)resource).defaultresources_getMetadataSupplier() == ResourceMetadata.EMPTY_SUPPLIER) {
            return new Resource(this.wrapResources(resource.source()), ((ResourceAccessor)resource).defaultresources_getStreamSupplier());
        }
        return new Resource(this.wrapResources(resource.source()), ((ResourceAccessor)resource).defaultresources_getStreamSupplier(), ((ResourceAccessor)resource).defaultresources_getMetadataSupplier());
    }

    private ResourceLocation wrapLocation(ResourceLocation location) {
        return location.withPath(s -> s.substring(this.prefix.length()));
    }

    private PackResources wrapResources(final PackResources pack) {
        return new PackResources(){

            public @Nullable IoSupplier<InputStream> getRootResource(String ... elements) {
                return pack.getRootResource(elements);
            }

            public @Nullable IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
                return pack.getResource(packType, location.withPrefix(WrappingResourceManager.this.prefix));
            }

            public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
                pack.listResources(packType, namespace, WrappingResourceManager.this.prefix + path, (rl, ioSupplier) -> resourceOutput.accept((Object)WrappingResourceManager.this.wrapLocation((ResourceLocation)rl), ioSupplier));
            }

            public Set<String> getNamespaces(PackType type) {
                return pack.getNamespaces(type);
            }

            public <T> @Nullable T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
                return (T)pack.getMetadataSection(deserializer);
            }

            public PackLocationInfo location() {
                return pack.location();
            }

            public String packId() {
                return pack.packId();
            }

            public void close() {
                pack.close();
            }
        };
    }

    public Optional<Resource> getResource(ResourceLocation location) {
        return this.wrapped.getResource(location.withPrefix(this.prefix)).map(this::wrapResource);
    }
}

